# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 10
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def mutual_trust_enhancer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust score (higher means opponent is more exploitable)
    trust_score = 0
    round_num = len(my_history) + 1
    
    # Early rounds: Build trust facade
    if round_num == 1:
        return "C"  # Unconditional cooperation to appear trustworthy
    elif round_num == 2:
        return "C"  # Reinforce cooperative illusion
    elif round_num == 3:
        return "D"  # Test opponent's tolerance with subtle defection
    
    # Mid-game: Adaptive exploitation based on opponent's reaction
    if round_num <= 7:
        if opp_history[-1] == "C":
            trust_score += 1  # Opponent is forgiving, increase exploitation
        else:
            trust_score -= 1  # Opponent retaliates, be cautious
        
        if trust_score > 0:
            return "D"  # Exploit forgiving opponent
        else:
            return "C" if random.random() < 0.5 else "D"  # Confuse retaliatory opponent
    
    # End-game: Ruthless defection if opponent is cooperative
    if round_num >= 8:
        if sum(1 for move in opp_history if move == "C") > sum(1 for move in opp_history if move == "D"):
            return "D"  # Maximize payoff against cooperative opponent
        else:
            return opp_history[-1]  # Mimic opponent's last move to avoid retaliation
    
    # Fallback (shouldn't reach here)
    return "D"